class WsController < WebsocketRails::BaseController

    protected

    def create_opened_chat(client, chat_id, owner = '', attendants = [])
        connection_store[:opened_chats] = {} if ! connection_store[:opened_chats]
        connection_store[:opened_chats][client] = {} if ! connection_store[:opened_chats][client]
        connection_store[:opened_chats][client][chat_id] = {owner: owner, attendants: attendants}
    end

    def find_client(client_jid)
        connection_store[:clients].find do |client|
            client.jid.strip.to_s == client_jid
        end
    end

    def where_i_am_multichat_owner(client)
        chats_owner = []

        if connection_store[:opened_chats] and connection_store[:opened_chats][client]
            connection_store[:opened_chats][client].each do |chat_id, contacts|
                if contacts[:owner] == client.jid.to_s
                    chats_owner << chat_id
                end
            end
        end

        chats_owner
    end

    def kick_from_all_multichats(client, somebody_to_kick)
        chats = where_i_am_multichat_owner(client)
        chats.each do |chat_id|
            contacts = connection_store[:opened_chats][client][chat_id][:attendants]
            #TODO: kontrola, ak ten clovek sa nenasiel v mutlichate - tak nic nerob
            contacts -= [somebody_to_kick.to_s]

            if contacts.empty?
                destroy_multichat(client.jid, chat_id)
            else
                contacts.each do |contact|
                    client.send(MessageBuilder::send_multichat_contacts(client.jid.to_s, contact, chat_id, contacts))
                end

                sync_contacts_frontend(client.jid, client.jid, chat_id, contacts)
            end
        end
    end

    def kick_myself_from_multichat(client, owner)
        if connection_store[:opened_chats] and connection_store[:opened_chats][client]
            connection_store[:opened_chats][client].each do |chat_id, chat|
                if chat[:owner] == owner.to_s and chat[:attendants].include? client.jid.to_s
                    destroy_multichat(client.jid, chat_id)
                end
            end
        end
    end

    def sync_contacts_frontend(owner, me, chat_id, contacts)
        send_message 'app.chat.updateSyncedContacts',
                     me: me.strip.to_s,
                     contacts: strip_all(contacts),
                     owner: owner.strip.to_s,
                     chat_id: chat_id
    end

    def destroy_multichat(me, chat_id)
        client = find_client(me.strip.to_s)
        connection_store[:opened_chats][client].delete(chat_id)

        send_message 'app.chat.destroyMultichat', chat_id: chat_id
    end

    def xml_contacts_to_array(xml_contacts)
        xml_contacts.get_elements('contact').map do |contact|
            contact.text
        end
    end

    def find_multichat_supported(jid_stripped)
        contact = connection_store[:presences][jid_stripped.to_sym].find do |resource, info|
            info[:multichat]
        end
        contact.first
    end

    def strip_all(contacts)
        if contacts.is_a? Array
            contacts.map do |jid|
                Jabber::JID.new(jid).strip!.to_s
            end
        else
            contacts
        end
    end
end