class WsRosterController < WebsocketRails::BaseController
    require 'xmpp4r/roster'
    require 'xmpp4r/vcard'

    def initialize
        super
        @storages = [:contacts, :clients, :rosters]
    end

    def initialize_storage
        @storages.each do |storage|
            connection_store[storage] = []
        end
    end

    def connect
        initialize_storage()

        clients = Token.fing_user_accounts_having_to_token(session[:token])

        clients.each do |credentials|
            begin
                client = Signin.try_login(credentials["jid"], credentials["pass"])
                client.send(Jabber::Presence.new.set_type(:available))

                connection_store[:clients] << client
                connection_store[:rosters] << Jabber::Roster::Helper.new(client)
            rescue Signin::LoginError
                trigger_failure msg: credentials["jid"]
            end
        end
    end

    ##
    # Vrat vsetkych priatelov v rosteri
    def get_contacts
        all_contacts = []

        connection_store[:rosters].each do |roster|
            roster.wait_for_roster
            roster.get_roster()

            roster.items.each do |jid, contact|
                all_contacts << {
                    jid: jid.to_s
                }
            end
        end

        trigger_success contacts: all_contacts
    end

    def disconnect
        if connection_store[:clients]
            connection_store[:clients].each do |client|
                client.send(Jabber::Presence.new.set_type(:unavailable))
            end
        end

        @storages.each do |storage|
            connection_store.delete(storage)
        end
    end

    ##
    # Pridaj noveho priatela do zoznamu
    def add_friend(data)

    end
end
