Xmpp.Views.Contacts ||= {}

class Xmpp.Views.Contacts.ListView extends Backbone.View
  template: JST["backbone/templates/contacts/contact_list"]

  initialize: () ->
    _.bindAll(this)

    @el = '#' + @attributes['id']
    @title = @attributes['title']

    @contacts = []

    @render()

  appendContact: (contact) ->
    @contacts.push = new Xmpp.Views.Contacts.ContactView(model: contact, attributes: {listView: this})

  render: (contacts) ->
    contacts ||= []
    json_contacts = new Array(contacts.length)
    _.each(contacts, (i, v) ->
      json_contacts[i] = v.toJSON()
    )

    $(@el).html(@template(title: @title, contacts: json_contacts))