class Xmpp.Models.Me extends Xmpp.Models.Contact
  namespace: 'app.roster'

  defaults:
    jid: ''
    name: ''
    status: 'online'
    message: ''
    avatar: ''

  initialize: ->
    _.bindAll(this)

    if ! @get('name')
      @set(name: @get('jid'))

    @view = new Xmpp.Views.Contacts.MeView(model: this)
    @view.render()

  sendMessage: (message, chatId, callbackOk, callbackFail) ->
    App.debug ['sending from:', @get('jid'), message]

    App.Com.sendMessage(message, chatId, @get('jid'), callbackOk, callbackFail)