module MessageBuilder
    def self.build_multi_messages(message, from, attendants, chat_id)
        attendants.map do |person|
            new_message = Jabber::Message.new(person, message)
            new_message.from = from
            new_message.add_attribute('chat_id', chat_id)
            new_message
        end
    end

    def self.build_message(message, from, to)
        message = Jabber::Message.new(to, message)
        message.from = from

        message
    end

    def self.ask_for_multichat_contacts(from, to, chat_id)
        message = Jabber::Message.new(to)
        message.from = from
        sync_request = REXML::Element.new('sync_contacts_request')
        sync_request.add_attributes('chat_id' => chat_id)
        message.add_element sync_request

        message
    end

    def self.send_multichat_contacts(from, to, chat_id, contacts)
        message = Jabber::Message.new(to)
        message.from = from
        sync_answer = REXML::Element.new('synced_contacts')
        collect_contacts(sync_answer, contacts)
        sync_answer.add_attributes('chat_id' => chat_id)
        message.add_element sync_answer

        message
    end

    def self.export_multichat(from, to, chat_id, contacts)
        message = Jabber::Message.new(to)
        message.from = from
        chat = REXML::Element.new('exported_chat')
        collect_contacts(chat, contacts)
        chat.add_attributes('chat_id' => chat_id)
        message.add_element chat

        message
    end

    def self.control_answer(from, to)
        message = Jabber::Message.new(to)
        message.from = from
        message.add_attributes('i_am_using_same_app' => 'true')

        message
    end

    def self.control_question(from, to)
        message = Jabber::Message.new(to)
        message.from = from
        message.add_attributes('are_you_using_my_app' => '?')

        message
    end

    def self.req_update_multichat_contacts(from, to, chat_id, changes)
        message = Jabber::Message.new(to)
        message.from = from
        message.add_attributes('req_update_contacts' => 'true')
        message.add_attributes('chat_id' => chat_id)

        added   = REXML::Element.new('added')
        removed = REXML::Element.new('removed')

        collect_contacts(added, changes[:added])
        collect_contacts(removed, changes[:removed])

        message.add_element added
        message.add_element removed

        message
    end

    def self.destroy_multichat(from, to, chat_id)
        message = Jabber::Message.new(to)
        message.from = from
        message.add_attributes('destroy_multichat' => 'true')
        message.add_attributes('chat_id' => chat_id)

        message
    end

    private

    def self.collect_contacts(to_element, contacts)
        if contacts.kind_of?(Array)
            contacts.each do |contact|
                contact_xml = REXML::Element.new('contact')
                contact_xml.text = contact
                to_element.add_element contact_xml
            end
        end
    end
end