class Xmpp.Models.Model extends Backbone.Model
  sync: (method, model, options) ->
    params = {}

    if (!options.event)
      params.event = model.namespace + '.' + method

    if (!options.data? && model && (method == 'create' || method == 'update' || method == 'patch'))
      params.data = JSON.stringify(options.attrs || model.toJSON(options))
    else
      params.data = JSON.stringify({})

    success = options.success;
    success = (resp) ->
      if (success)
        success(model, resp, options)
      model.trigger('sync', model, resp, options)

    error = options.error
    options.error = (xhr) ->
      if (error)
        error(model, xhr, options)
      model.trigger('error', model, xhr, options);

    result = options.result = App.Com.fetch(_.extend(params, options))

    model.trigger('request', model, result, options)
    return result