Xmpp.Views.Contacts ||= {}

class Xmpp.Views.Contacts.ContactView extends Backbone.View
  template: JST["backbone/templates/contacts/contact"]
  tagName: 'li'
  className: 'clear user'

  events:
    'click .invite': 'inviteToMultichat'
    'click .kick': 'kickFromMultiChat'
    'click .multichat': 'newMultiChat'
    click: 'startChat'
    mouseover: 'showIcons'
    mouseleave: 'hideIcons'

  initialize: () ->
    _.bindAll(this)

#    Patrim nejakemu zoznamu
    @parentList = @attributes['listView']

    @model.on('change', @updateContact)
    @model.on('change:status', => @parentList.reOrder())

  updateContact: (contact) ->
    @model = contact
    @render()

  hide: ->
    $(@el).hide()

  unhide: ->
    $(@el).show()

  render: ->
    contact = @model.toJSON()
    $(@el).html(@template(contact))
    return this

  belongsToActiveList: ->
    @parentList.activeGroup == true

  startChat: ->
    who      = App.Models.me
    withWhom = @model

    App.debug ['opening chat with: ', who.get('jid'), withWhom.get('jid')]

    chat = App.Collections.chats.find(who, withWhom)
    if (! chat)
      App.debug ['not found in opened chats, creating new']
      chat = new Xmpp.Models.Chat(who: who, withWhom: withWhom)
      App.Collections.chats.add(chat)

    Backbone.Events.trigger('openChat', chat)

  inviteToMultichat: (e) ->
    e.stopPropagation()
    App.debug 'iniviting to multichat'
    multichat = App.Collections.chats.activeChat
    if not multichat or not multichat.get('isMultiChat')
      return

    App.Com.inviteToChat(multichat, @model, App.Models.me.get('jid'))

  newMultiChat: (e) ->
    e.stopPropagation()
    App.debug 'new multichat'

    newChat = new Xmpp.Models.Chat(isMultiChat: true)
    newChat.set('who', App.Models.me)

    App.Collections.chats.add(newChat)
    App.Com.openNewMultiChat(App.Models.me, @model, newChat)

  kickFromMultiChat: (e) ->
    e.stopPropagation()
    App.debug 'kick him from multichat!'

    multichat = App.Collections.chats.activeChat
    if not multichat or not multichat.get('isMultiChat')
      return

    App.Com.kickFromMultichat(multichat.get('chatId'), App.Models.me.get('jid'), @model.get('jid'))
    App.Collections.contacts.moveToInactiveList(@model)

  openChatById: (chatId) ->
    App.Collections.chats.findById(chatId)

  showIcons: ->
    activeChat = App.Collections.chats.activeChat

    $(@el).find('.action .multichat, .action .invite, .action .kick').hide()

    if (@model.get('usingMyApp'))
      if not activeChat or not activeChat.get('isMultiChat')
        $(@el).find('.action .multichat').show()
      else if activeChat.get('isMultiChat') and activeChat.isMeOwner() and not activeChat.isAttending(@model)
        $(@el).find('.action .invite').show()
      else if activeChat.get('isMultiChat') and activeChat.isMeOwner()
        $(@el).find('.action .kick').show()

  hideIcons: ->
    $(@el).find('.action .multichat, .action .invite, .action .kick').hide()
