Xmpp.Views.Tabbar ||= {}

class Xmpp.Views.Tabbar.TabView extends Backbone.View
  template: JST["backbone/templates/tabbar/tab"]
  tagName: 'div'
  className: 'tab'

  events:
    'click .js-close': 'closeChat'

  initialize: () ->
    _.bindAll(this)

  setActive: ->
    $(@el).addClass('active')
    @render()

  setInactive: ->
    $(@el).removeClass('active')
    @render()

  render: ->
    $(@el).html(@template(
      who:      @model.get('who').firstname(),
      withWhom: @model.get('withWhom').firstname()
    ))
    return this

  showChat: ->
    if !@chatWindow
      @chatWindow = new Xmpp.Views.Chat.WindowView(attributes: {tab: this})
      App.debug 'zobrazujem NOVY chat window'
    else
      App.debug 'zobrazujem EXISTUJUCI chat window'

    @chatWindow.render()

  destroy: ->
    App.debug 'destroy chatWindow and tab'
    @chatWindow.remove()
    @remove()

  hideChat: ->
    if @chatWindow
      @chatWindow.hide();

  closeChat: ->
    Backbone.Events.trigger('closeChat', this, @model)
    @destroy()

  hasParticipants: (who, withWhom) ->
    @model && @model.get('who') == who && @model.get('withWhom') == withWhom
