require "spec_helper"

describe "Chatting behaviour" do

    #todo change subject in testing roster and chatting window
	subject { page }

	describe "should show account info" do
		before { visit chat_path }

		it { should have_selector('h1', text: 'Cinan Rakosnik') }
		it { should have_selector('h2', text: 'frontend developer') }
		it { should have_selector('h3', text: 'available') }
	end

	describe "should show contact list" do
		before { visit chat_path }

		it { should have_selector('h1', 'Friends') }

		it { should have_selector('h1', 'John Savage') }
		it { should have_selector('h1', 'Adam Wolsky') }
    end

    describe "should show tabbar" do
        before { visit chat_path }

        it { should have_selector(class: 'tabbar') }
        it { should have_selector('h1', text: 'Adam and John', class: 'tab') }
    end

    describe "should a conversation" do
        before { visit chat_path }

        describe "show some messages" do
            it { should have_selector('img') }
            it { should have_selector(class: 'date') }
            #todo should have a message text
        end

        describe "should show event dates" do
            it { should have_selector(text: 'Monday 13.2.2013') }
        end

        describe "should allow write a new message" do
            it { should have_selector('input', placeholder: 'Type your message here') }
            it { should have_button('Send') }
        end
    end
end