class Xmpp.Models.Chat extends Xmpp.Models.Model
  namespace: 'app.chat'

  defaults:
    who: null
    withWhom: null

  initialize: ->
    _.bindAll(this)

class Xmpp.Collections.ChatsCollection extends Backbone.Collection
  model: Xmpp.Models.Chat
  openedChats: []

  initialize: ->
    _.bindAll(this)

    @on("add", @newChat)

  newChat: (chat) ->
#    App.debug ['adding chat to chatCollection', chat]
    @openedChats.push chat

  find: (who, withWhom) ->
#    App.debug ['opened chats:', @openedChats]

    _.find(@openedChats, (chat) ->
      chat.get('who') == who && chat.get('withWhom') == withWhom
    )

  removeChat: (chat) ->
    @openedChats = _.without(@openedChats, chat)