Xmpp.Views.Chat ||= {}

class Xmpp.Views.Chat.WindowView extends Backbone.View
  template: JST["backbone/templates/chat/window"]
  el: $('#conversation-js')

  events:
    'submit #msg-writer': (e) -> @sendMessage(e)

  initialize: () ->
    _.bindAll(this)
    @tab = @attributes['tab']
    @date = new Date() #pre testovacie ucely

  render: ->
    $(@el).html(@template(date: @date.getTime(), showWriter: true))
    @show()
    return this

  hide: ->
    $(@el).addClass('hidden')
    this

  show: ->
    $(@el).removeClass('hidden')
    this

  remove: ->
    @undelegateEvents()
    $(@el).empty()
    # @stopListening() TODO: po upgrade na 1.0 uz bude pristupne
    this

  sendMessage: (e) ->
    e.preventDefault()
    $this = $(e.currentTarget)
    input = $this.find('input[type=text]')
    message = input.val().trim()

    if (message)
      @tab.getOwner().sendMessage(message, 1) #1 = chatId

