this.App =
  debug: (msg) ->
    console.log msg

  UI:
    setAutoHeight: ->
      height = $(window).height()
      $("#height-setter-1").css({height: height - 50})
      $("#height-setter-2").css({height: height - $('#tabbar').outerHeight() - $('#msg-writer').outerHeight() - 57})

    filterContacts: (searchTerm) ->
      App.Collections.contacts.filter(searchTerm)

  Com:
    connect: (callback) ->
      App._dispatcher = new WebSocketRails('www.xmpp.dev:3000/websocket')
      App._dispatcher.on_open = =>
        @_setupBackboneComponents()
        @_bindEvents()
        callback?()

    trigger: (options) ->
      _.defaults(options, {data: {} })
      App._dispatcher.trigger(options.event, options.data, options.success, options.error)

    initRoster: ->
      App.Com.trigger(
        event: 'app.roster.initRoster'
        success: (data) ->
          _.each(data.contacts, (contact) ->
            newContact = new Xmpp.Models.Contact(
              id: contact.jid
              jid: contact.jid
              belongsTo: [contact.belongsTo]
            )
            App.Collections.contacts.add(newContact, merge: true)
          )
      )

    startFetchingVcards: ->
      App.Com.trigger(event: 'app.roster.startFetchingVcards')

    startPollingRoster: ->
      App.Com.trigger(event: 'app.roster.startPolling')

    setPresence: ->
      App.Com.trigger(event: 'app.roster.setPresence')

    getMe: ->
      App.Com.trigger(event: 'app.roster.myself', success: (response) ->
        App.Models.me = new Xmpp.Models.Me(
          jid: response.jid
          name: response.vcard.name
          status: response.status
          avatar: response.vcard.avatar
        )
      )

    sendMessage: (message, chatId, from) ->
      App.Com.trigger(event: 'app.chat.sendMessage', data: {message: message, chatId: chatId, from: from}, success: ->
        App.debug 'message sent from server'
      )

    openNewChatId: (chatOwner, attendant, chat) ->
      @trigger(event: 'app.chat.newChatId', data: {chatOwner: chatOwner}, success: (response) =>
        chat.setChatId(response.id)
        @trigger(event: 'app.chat.addToChat', data: {chatOwner: chatOwner, chatId: response.id, jid: attendant} )
      )

    updateMyStatus: (message, state)->
      App.Com.trigger(event: 'app.roster.updateMyStatus', data: {message: message, state: state})

    removeContactRemote: (contact, client) ->
      App.Com.trigger(event: 'app.roster.removeContact', data: {jid: contact, client: client})

    _setupBackboneComponents: ->
      App.Collections.contacts = new Xmpp.Collections.ContactsCollection()
      App.Collections.chats = new Xmpp.Collections.ChatsCollection()

      App.Views.tabbar = new Xmpp.Views.Tabbar.TabbarView()

    _bindEvents: ->
      App._dispatcher.bind('app.roster.statusChanged', (result) ->
        App.debug 'change contact state'
        App.Collections.contacts.updateStatus(result)
      )

      App._dispatcher.bind('app.roster.vcard', (result) ->
        App.debug 'got vcard'
        App.Collections.contacts.udpateVcard(result)
      )

      App._dispatcher.bind('app.roster.subscriptionChanged', (subscription) ->
        App.debug 'subscription changed'
        App.Collections.contacts.subscriptionChanged(subscription)
      )

  Models:
    me: null

  Collections:
    contacts: null
    chats: null

  Views:
    tabbar: null
    chat: null
