Xmpp.Views.Chat ||= {}

class Xmpp.Views.Chat.WindowView extends Backbone.View
  template: JST["backbone/templates/chat/window"]
  el: $('#conversation-js')

  events:
    'submit #msg-writer': (e) -> @sendMessage(e)

  initialize: () ->
    _.bindAll(this)
    @tab = @attributes['tab']
    @historyStack = []

  render: ->
    historyStackHtml = _.map(@historyStack, (view) ->
      view.render().el.outerHTML
    )
    $(@el).html(@template(showWriter: true, history: historyStackHtml))
    @show()
    return this

  hide: ->
    $(@el).addClass('hidden')
    @undelegateEvents()
    this

  show: ->
    $(@el).removeClass('hidden')
    @delegateEvents()
    this

  remove: ->
    @undelegateEvents()
    $(@el).empty()
    @stopListening()
    _.each(@historyStack, (item)->
      item.remove()
    )
    return this

  sendMessage: (e) ->
    e.preventDefault()
    $this = $(e.currentTarget)
    input = $this.find('input[type=text]')
    message = input.val().trim()
    input.val('')

    if (message)
      @tab.getOwner().sendMessage(message, @tab.getChatId()
      , (message) =>
        @sendSuccess(@tab.getOwner(), message)
      , (message) ->
        @sendFail(message))

  sendSuccess: (me, msg) ->
    @appendMessage(me, new Date(), msg)

  sendFail: ->
    @appendEvent(I18n.t('chat.window.sendFailed'), false)

  appendEvent: (msg, logMe) ->
    App.debug ['append event', msg]
#    @log(eventView) if logMe == true

  appendMessage: (user, date, msg) ->
    messageView = new Xmpp.Views.Chat.MessageView(user: user, date: date, message: msg)
    $(@el).find('#msg-writer').before(messageView.render().el)
    @log(messageView)

  log: (view) ->
    @historyStack.push(view)
#    App.debug @historyStack
