class ApplicationController < ActionController::Base

	before_filter :require_login

	def require_login
		if authenticated?
			create_new_authentification()

            unless controller_name == 'chat'
                redirect_to chat_template_path
            end
		else
			unless controller_name == 'sessions' && (action_name == 'new' || action_name == 'create')
                redirect_to root_url, flash: {error: I18n.t('login.access-denied')}
			end
		end
	end

	protected

	def authenticated?
		!! Token.authenticate(session)
	end

	def create_new_authentification
		Token.remove_old_session(session[:token])

		session[:token] = Token.generate_token()
		session[:created_at] = Time.now
		session[:ip] = request.remote_ip

		Token.save_session(session)
	end
end
