class WsController < WebsocketRails::BaseController

    protected

    def create_opened_chat(client, chat_id, owner = '', attendants = [])
        connection_store[:opened_chats] = {} if ! connection_store[:opened_chats]
        connection_store[:opened_chats][client] = {} if ! connection_store[:opened_chats][client]
        connection_store[:opened_chats][client][chat_id] = {owner: owner, attendants: attendants}
    end

    def find_client(client_jid)
        connection_store[:clients].find do |client|
            client.jid.strip.to_s == client_jid
        end
    end

    def where_i_am_multichat_owner
        chats_owner = {}

        if connection_store[:opened_chats]
            connection_store[:clients].each do |client|
                connection_store[:opened_chats][client].each do |chat_id, contacts|
                #    if contacts[:owner] == client.jid.strip.to_s
                #        chats_owner[client] = chat_id
                #    end
                end
            end
        end

        chats_owner
    end

    def kick_from_all_multichats(kick)
        chats = where_i_am_multichat_owner()
        chats.each do |client, chat_id|
            contacts = connection_store[:opened_chats][client][chat_id][:attendants]
            contacts -= [kick]

            if contacts.empty?
                destroy_multichat(client.jid.strip.to_s, chat_id)
            else
                contacts.each do |contact|
                    client.send(MessageBuilder::send_multichat_contacts(client.jid.strip.to_s, contact, chat_id, contacts))
                end

                sync_contacts_frontend('', client.jid.strip.to_s, chat_id, contacts)
            end
        end
    end

    def sync_contacts_frontend(from, to, chat_id, contacts)
        send_message 'app.chat.updateSyncedContacts',
                     me: to,
                     contacts: contacts,
                     owner: from,
                     chat_id: chat_id
    end

    def destroy_multichat(to, chat_id)
        client = find_client(to)
        connection_store[:opened_chats][client].delete(chat_id)

        send_message 'app.chat.destroyMultichat', chat_id: chat_id
    end

    def xml_contacts_to_array(xml_contacts)
        xml_contacts.get_elements('contact').map do |contact|
            contact.text
        end
    end

    def find_multichat_supported(jid_stripped)
        contact = connection_store[:presences][jid_stripped.to_sym].find do |resource, info|
            info[:multichat]
        end
        contact.first
    end

    def strip_all(contacts)
        if contacts.is_a? Array
            contacts.map do |jid|
                Jabber::JID.new(jid).strip!.to_s
            end
        else
            contacts
        end
    end
end