Xmpp.Views.Contacts ||= {}

class Xmpp.Views.Contacts.ContactView extends Backbone.View
  template: JST["backbone/templates/contacts/contact"]
  tagName: 'li'
  className: 'clear user'

  events:
    'click': 'startChat'

  initialize: () ->
    _.bindAll(this)

#    Patrim nejakemu zoznamu
    @parentList = @attributes['listView']

    @model.on('change', @updateContact, this)

  updateContact: (contact) ->
    @model = contact
    @render()

  render: ->
    contact = @model.toJSON()
    $(@el).html(@template(contact))
    return this

  belongsToActiveList: ->
    @parentList.activeGroup == true

  startChat: (event) ->
    if @belongsToActiveList()
      return

    who      = App.Models.me
    withWhom = @model

    App.debug ['opening chat with: ', who.get('jid'), withWhom.get('jid')]

    chat = App.Collections.chats.find(who, withWhom)
    if (! chat)
#      App.debug ['not found in opened chats, creating new', chat]
      chat = new Xmpp.Models.Chat(who: who, withWhom: withWhom)
      App.Collections.chats.add(chat)

    App.Views.tabbar.addOrSelect(chat)
    App.Collections.contacts.moveToInactiveList('all')
    App.Collections.contacts.moveToActiveList(withWhom)
#    @openChat(chat)

  openChat: (chat) ->

