class SessionsController < ApplicationController
	def new

	end

	def create
		begin
			Signin.try_login(params[:jid].downcase, params[:password])
		rescue Signin::LoginError
			flash.now[:error] = I18n.t 'login.error'
			return render 'new'
		end

        create_new_authentication({
            jid: params[:jid].downcase,
            password: params[:password]
        })

        redirect_to chat_path, flash: {notice: I18n.t('login.success')}
	end

	def destroy
        Token.remove_token(session[:token])
        remove_session()

        redirect_to root_path
	end
end
