class User
	include Mongoid::Document

	field :jids, type: Array

    def update_pass(jid, pass)
        account_credentials = jids.detect do |f|
            f[:jid] == jid || f["jid"] == jid
        end

        account_credentials[:pass] = pass
        save
    end

    def self.existing_jid(jid)
        where("jids.jid" => jid).only(:jids).first
    end

    def self.create_jid(jid)
        new_user = new(jids: [ {jid: jid} ])
        new_user.save
        new_user
    end

    def add_account(another_jid, password)
        jids << {jid: another_jid, pass: password}
        save
    end
end