Xmpp.Views.Tabbar ||= {}

class Xmpp.Views.Tabbar.TabbarView extends Backbone.View
  template: JST["backbone/templates/tabbar/tabbar"]
  el: $('#js-tabbar')

  initialize: () ->
    _.bindAll(this)

    Backbone.Events.on('openChat', (chat) =>
      @hideCurrentChatWindow()
      @addOrSelect(chat)
    )
    Backbone.Events.on('closeChat', @removeTab)

    @tabs = []
    @activeTab = null
    @render()

  addOrSelect: (chat) ->
    tab = _.find(@tabs, (tab) ->
      tab.hasParticipants(chat.get('who'), chat.get('withWhom'))
    )

    if (!! tab)
      App.debug 'selecting existing tab'
    else
      App.debug 'adding new tab'
      tab = new Xmpp.Views.Tabbar.TabView(model: chat)
      @tabs.push tab
      $(@el).append(tab.render().el)

    _.each(@tabs, (tab) ->
      tab.setInactive()
    )

    @activeTab = tab
    @activeTab.setActive()

    @activeTab.showChat()
#    App.debug ['aktivny tab: ', @activeTab]

  hideCurrentChatWindow: ->
    if @activeTab
      App.debug 'zakryvam chat window'
      @activeTab.hideChat()

  removeTab: (tab) ->
#    if @activeTab && @activeTab == tab
#      App.debug 'nicim tab aj chat window'
#      @activeTab.destroy()

    @tabs = _.without(@tabs, tab)

  render: ->
    $(@el).html(@template())
    return this
