require 'spec_helper'

describe "Authentication" do

	subject { page }

	describe "signin page" do
		before { visit signin_path }

		it { should have_selector('h1',    text: 'Login') }
		it { should have_title('Login') }
	end

	describe "signin" do
		before { visit signin_path }

		describe "with invalid information" do
			before { click_button I18n.t("sessions.new.form-send") }

			it { should have_title('Login') }
			it { should have_selector('div.alert.alert-error', text: 'Invalid') }
		end

		describe "with valid information" do
			before do
				fill_in "jid",      with: 'bakalar@jabbim.cz'
				fill_in "password", with: 'tralala'
				click_button I18n.t("sessions.new.form-send")
			end

			#it { should have_title(user.name) }
			#it { should have_link('Profile', href: user_path(user)) }
			#it { should have_link('Logout', href: signout_path) }
			#it { should_not have_link('Login', href: signin_path) }

			it {should have_selector('div.alert.alert-notice', text: 'Success')}
		end
	end
end