class Xmpp.Models.Contact extends Xmpp.Models.Model
  namespace: 'app.roster'

  defaults:
    status: ''
    state: 'online'

  initialize: ->
    _.bindAll(this)

class Xmpp.Collections.ContactsCollection extends Backbone.Collection
  model: Xmpp.Models.Contact

  initialize: ->
    _.bindAll(this)
    @counter = 0
    @friendsList = new Xmpp.Views.Contacts.ListView(collection: this, attributes: {title: 'chat.roster.friends', id: 'js-inactive-friends'})
#    @activeList  = new Xmpp.Views.Contacts.ListView(collection: this, attributes: {title: 'chat.roster.chat-group', id: 'js-active-friends'})

    @on("add", @appendContact)

  appendContact: (contact) ->
    @counter++
    @friendsList.appendContact(contact)