class ApplicationController < ActionController::Base
  #protect_from_forgery

	before_filter :require_login

	def require_login
		#if controller_name == 'sessions' && action_name == 'new'
		#	true
		#end

		if authenticated?
			create_new_authentification()
		else
			#create_new_authentification()
			#Redirect to login page
		end
	end

	protected

	def authenticated?
		!! Token.authenticate(session)
	end

	def create_new_authentification
		Token.remove_old_session(session[:token])

		session[:token] = Token.generate_token()
		session[:created_at] = Time.now
		session[:ip] = request.remote_ip

		Token.save_session(session)
	end
end
