Xmpp.Views.Popup ||= {}

class Xmpp.Views.Popup.AddContactView extends Xmpp.Views.Popup.PopupView
  template: JST["backbone/templates/popup/add_contact"]
  className: 'add-contact'

  events:
    'submit form': 'addContact'

  initialize: ->
    @events = _.extend(@events, @superEvents())

  render: ->
    super(@template())
    $(@el).css(width: '20%', 'z-index': 999)
    $(@el).find('input[type=text]').focus()
    this

  addContact: (e) ->
    e.preventDefault()
    jid = $(@el).find('input[name=jid]').val()
    r = new RegExp('^.+@.+\..+$')
    match = r.exec(jid)
    if match and (match.length > 0)
      jid = App.stripJid(match[0])
      App.Com.addContact(jid)
