Xmpp.Views.Contacts ||= {}

class Xmpp.Views.Contacts.ContactView extends Backbone.View
  template: JST["backbone/templates/contacts/contact"]
  tagName: 'li'
  className: 'clear user'

  events:
    'click': 'startChat'

  initialize: () ->
    _.bindAll(this)

    # Patrim nejakemu zoznamu
    @parentList = @attributes['listView']

    @model.on('change', @updateContact, this)

  updateContact: (contact) ->
    @model = contact
    @render()

  render: ->
    contact = @model.toJSON()
    $(@el).html(@template(contact))
    return this

  startChat: (event) ->
    who = App.Models.me
    withWhom = @model

    App.debug ['opening chat with: ', who.get('jid'), withWhom.get('jid')]

    chat = App.Collections.chats.find(who, withWhom)
    if (! chat)
#      App.debug ['not found in opened chats, creating new', chat]
      chat = new Xmpp.Models.Chat(who: who, withWhom: withWhom)
      App.Collections.chats.add(chat)

    App.Views.tabbar.addOrSelect(chat)
#    @openChat(chat)

  openChat: (chat) ->

