class Xmpp.Models.Contact extends Xmpp.Models.Model
  namespace: 'app.roster'

  defaults:
    jid: ''
    name: ''
    status: 'offline'
    message: ''
    avatar: ''
    belongsTo: ''

  initialize: ->
    _.bindAll(this)

    if ! @get('name')
      @set(name: @get('jid'))

  firstname: ->
    @get('name').split(' ')[0]

class Xmpp.Collections.ContactsCollection extends Backbone.Collection
  model: Xmpp.Models.Contact

  initialize: ->
    _.bindAll(this)
    @counter = 0
    @friendsList = new Xmpp.Views.Contacts.ListView(collection: this, attributes: {title: 'chat.roster.friends', id: 'js-inactive-friends'})
#    @activeList  = new Xmpp.Views.Contacts.ListView(collection: this, attributes: {title: 'chat.roster.chat-group', id: 'js-active-friends'})

    @on("add", @appendContact)

  appendContact: (contact) ->
    @counter++
    @friendsList.appendContact(contact)

  updateStatus: (response) ->
    @get(response.jid).set(message: response.status.message, status: response.status.status)

  udpateVcard: (response) ->
    @get(response.jid).set(name: response.vcard.name, avatar: response.vcard.avatar)