class WsRosterController < WebsocketRails::BaseController
    require 'xmpp4r/roster'
    require 'xmpp4r/vcard'

    def initialize
        super
        @storages = [:contacts, :clients, :rosters]
    end

    def initialize_storage
        @storages.each do |storage|
            connection_store[storage] = []
        end

        connection_store[:link_roster_client] = {}
    end

    ##
    # Pripoj sa na jabber ucty.
    def connect
        initialize_storage()

        clients = Token.fing_user_accounts_having_to_token(session[:token])

        clients.each do |credentials|
            begin
                client = Signin.try_login(credentials["jid"], credentials["pass"])
                connection_store[:clients] << client
            rescue Signin::LoginError
                send_message 'app.client.cannot_connect', true
            end
        end
    end

    ##
    # Inicializuj roster so zoznamom ludi v nom.
    # Vrat zoznam ludi (ich JID).
    def init_roster
        all_jids = []

        connection_store[:clients].each do |client|
            roster = Jabber::Roster::Helper.new(client)

            connection_store[:rosters] << roster
            connection_store[:link_roster_client][roster] = client

            roster.get_roster()
            roster.wait_for_roster()

            roster.items.each do |jid, contact|
                all_jids << jid.to_s
            end
        end

        trigger_success contacts: all_jids
    end

    ##
    # Stiahni vcard ludi v rosteri
    def start_fetching_vcards
        connection_store[:rosters].each do |roster|
            client = connection_store[:link_roster_client][roster]

            roster.items.each do |jid, contact|
                Thread.new do
                    vcard = get_vcard(client, jid.to_s)
                    send_message 'app.roster.vcard', jid: jid.to_s, vcard: vcard
                end
            end
        end
    end

    ##
    # Zacni pocuvat zmeny stavov v rosteri
    def start_polling_contacts_state
        connection_store[:rosters].each do |roster|
            roster.add_presence_callback do |roster_item, old_presence, new_presence|
                if new_presence.type == :unavailable
                    result = {status: :offline, message: ''}
                else
                    status = new_presence.show
                    status = case status
                        when :away, :xa then :away
                        when :dnd       then :dnd
                        else                 :online
                    end

                    result = { status: status, message: new_presence.status.to_s }
                end

                send_message 'app.roster.statusChanged',
                             jid: roster_item.jid.strip.to_s, status: result
            end

            # ak by som poslal svoju Presence, tak add_presence_callback nezachyti
            # stav ludi, ktore sa odosielaju hned po zadani mojej Presence
            client = connection_store[:link_roster_client][roster]
            client.send(Jabber::Presence.new.set_type(:available))
        end
    end

    def disconnect
        connection_store[:clients] && connection_store[:clients].each do |client|
            client.close()
        end

        @storages.each do |storage|
            connection_store.delete(storage)
        end
    end

    ##
    # Pridaj noveho priatela do zoznamu
    def add_friend(data)

    end

    private

    def get_vcard(my_client, contacts_jid)
        vcard = Jabber::Vcard::Helper.get(my_client, contacts_jid)

        { name: vcard && (vcard["FN"] || vcard["NICKNAME"]) || contacts_jid,
          avatar: '' #TODO avatar
        }
    end
end
