Xmpp.Views.Contacts ||= {}

class Xmpp.Views.Contacts.ListView extends Backbone.View
  template: JST["backbone/templates/contacts/contact_list"]

  initialize: () ->
    _.bindAll(this)

    @el = '#' + @attributes['id']
    @title = @attributes['title']

    @contactViews = []

    @createListContainer()

  createListContainer: ->
    $(@el).html(@template(title: @title))

  appendContact: (contact) ->
    view =  new Xmpp.Views.Contacts.ContactView(model: contact, attributes: {listView: this})
    @contactViews.push view
    @render(view.render().el)

  render: (contactHtml) ->
    if (contactHtml?)
      $(@el).find('ul').append(contactHtml)
    else
      _.each(@contactViews, (i, contact) =>
        @render(contact.render().el)
      )

    return this