Xmpp.Views.Tabbar ||= {}

class Xmpp.Views.Tabbar.TabView extends Backbone.View
  template: JST["backbone/templates/tabbar/tab"]
  tagName: 'div'
  className: 'tab'

  events:
    'click .js-close': 'closeChat'

  initialize: () ->
    _.bindAll(this)

  setActive: ->
    $(@el).addClass('active')
    @render()

  setInactive: ->
    $(@el).removeClass('active')
    @render()

  render: ->
    $(@el).html(@template(
      who:      @model.get('who').firstname(),
      withWhom: @model.get('withWhom').firstname()
    ))
    return this

  closeChat: ->
    App.Views.tabbar.removeTab(this)
    App.Collections.chats.removeChat(@model)
    App.Collections.contacts.moveToInactiveList(@model.get('withWhom'))
    @remove()

  hasParticipants: (who, withWhom) ->
    @model && @model.get('who') == who && @model.get('withWhom') == withWhom
