Xmpp.Views.Chat ||= {}

class Xmpp.Views.Chat.MessageView extends Backbone.View
  template: JST["backbone/templates/chat/message"]
  className: 'message-box'

  initialize: (parts) ->
    _.bindAll(this)

    @user = parts.user
    @dateSent = parts.date
    @message = parts.message

  render: ->
    $(@el).html(@template(username: @user.get('name'), avatar: @user.get('avatar'), date: @formatTime(), message: @message))
    return this

  formatTime:  ->
    nowDate = new Date()
    if (nowDate.getDate() != @dateSent.getDate() &&
        nowDate.getMonth() != @dateSent.getMonth() &&
        nowDate.getFullYear() != @dateSent.getFullYear())
      return @dateSent.getFullYear() + '/' + (@dateSent.getMonth()+1) + '/' + @dateSent.getDate() +
        ' @ ' + @dateSent.getHours() + ':' + @dateSent.getMinutes()

    return @dateSent.getHours() + ':' + @dateSent.getMinutes()