Xmpp.Views.Popup ||= {}

class Xmpp.Views.Popup.FriendRequestView extends Xmpp.Views.Popup.PopupView
  template: JST["backbone/templates/popup/friend_request"]

  events:
    'submit form': 'approve'

  initialize: (options) ->
    @name = options.name
    @jid  = options.jid

    @events = _.extend(@events, @superEvents)

  render: ->
    super(@template(new_contact: @name))
    $(@el).css(width: '20%', 'z-index': 999)
    $(@el).find('input[type=text]').focus()
    this

  approve: (e) ->
    e.preventDefault()
    App.debug 'approve request'
    App.Com.answerFriendRequest(@jid, true)
    @remove()

  close: (e) ->
    e.preventDefault()
    App.debug 'cancel request'
    App.Com.answerFriendRequest(@jid, false)
    @remove()