require 'test_helper'
require 'ipaddr'

class UserTest < ActiveSupport::TestCase

	def setup

	end

	def teardown
		User.delete_all()
	end

	test "create new account" do
        jid = "jid@example.com"
        User.create_jid(jid)

        assert_not_nil User.existing_jid(jid).first
    end

    test "set password" do
        jid = "name@example.com"
        pass = "password"

        user = User.create_jid(jid)
        user.update_pass(jid, pass)

        assert_not_nil User.where("jids.jid" => jid, "jids.pass" => pass).first
    end

    test "add another account" do
        jid = "name@example.com"

        jid2 = "name2@example.com"
        pass = "pass"

        user = User.create_jid(jid)

        user.add_account(jid2, pass)

        assert_equal 2, User.existing_jid(jid).jids.count
    end
end
