class Xmpp.Models.Me extends Xmpp.Models.Contact
  namespace: 'app.roster'

  defaults:
    jid: ''
    name: ''
    status: 'online'
    message: ''
    avatar: ''

  initialize: ->
    _.bindAll(this)

    if ! @get('name')
      @set(name: @get('jid'))

    @view = new Xmpp.Views.Contacts.MeView(model: this)
    @view.render()

  sendMessage: (message, chatId, to, callbackOk, callbackFail) ->
    App.debug ['sending from:', @get('jid'), message]

    if (! chatId)
      App.Com.sendMessage(message, to, @get('jid'), callbackOk, callbackFail)
    else
      App.Com.sendMultiMessage(message, chatId, @get('jid'), callbackOk, callbackFail)