class ActiveSupport::BufferedLogger
    def formatter=(formatter)
        @log.formatter = formatter
    end
end

class Formatter
    SEVERITY_TO_COLOR_MAP   = {'DEBUG'=>'33', 'INFO'=>'0;37', 'WARN'=>'36', 'ERROR'=>'31', 'FATAL'=>'31', 'UNKNOWN'=>'37'}
    USE_HUMOROUS_SEVERITIES = false

    def call(severity, time, progname, msg)
        formatted_severity = sprintf("%s","#{severity}")

        formatted_time = time.strftime("%Y-%m-%d %H:%M:%S.") << time.usec.to_s[0..2].rjust(3)
        color = SEVERITY_TO_COLOR_MAP[severity]

        if msg.empty?
            "\n"
        else
            "\033[0;37m#{formatted_time}\033[0m [#{formatted_severity}] \033[#{color}m#{msg.strip}\033[0m\n"
        end
    end

end

Rails.logger.formatter = Formatter.new