import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobs = [
    { jobId: 1, t: 3 },
    { jobId: 2, t: 9 },
    { jobId: 3, t: 5 },
    { jobId: 4, t: 7 },
    { jobId: 5, t: 6 },
  ];

  const schedule = createSchedule(jobs, 3);

  expect(schedule.length).toBe(7);
  expect(schedule[0]).toEqual({ jobId: 1, t: 3, c: 3, processor: 1 });
  expect(schedule[1]).toEqual({ jobId: 2, t: 7, c: 10, processor: 1 });
  expect(schedule[2]).toEqual({ jobId: 2, t: 2, c: 2, processor: 2 });
  expect(schedule[3]).toEqual({ jobId: 3, t: 5, c: 7, processor: 2 });
  expect(schedule[4]).toEqual({ jobId: 4, t: 3, c: 10, processor: 2 });
  expect(schedule[5]).toEqual({ jobId: 4, t: 4, c: 4, processor: 3 });
  expect(schedule[6]).toEqual({ jobId: 5, t: 6, c: 10, processor: 3 });
});

test('create gantt', () => {
  const jobs = [
    { jobId: 1, t: 3, name: 'a' },
    { jobId: 2, t: 9, name: 'b' },
    { jobId: 3, t: 5, name: 'c' },
    { jobId: 4, t: 7, name: 'd' },
    { jobId: 5, t: 6, name: 'e' },
  ];

  const template = createGantt(jobs, 3);

  expect(template.length).toBe(3);
  expect(template[0].length).toBe(2);
  expect(template[1].length).toBe(3);
  expect(template[2].length).toBe(2);
  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 3 , name: 'a'});
  expect(template[0][1]).toEqual({ processor: 1, startTime: 3, endTime: 10, name: 'b' });
  expect(template[1][0]).toEqual({ processor: 2, startTime: 0, endTime: 2 , name: 'b'});
  expect(template[1][1]).toEqual({ processor: 2, startTime: 2, endTime: 7 , name: 'c'});
  expect(template[1][2]).toEqual({ processor: 2, startTime: 7, endTime: 10, name: 'd' });
  expect(template[2][0]).toEqual({ processor: 3, startTime: 0, endTime: 4 , name: 'd'});
  expect(template[2][1]).toEqual({ processor: 3, startTime: 4, endTime: 10, name: 'e' });
});