import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobs = [
    { jobId: 1, t: 6, d: 10 },
    { jobId: 2, t: 8, d: 25 },
    { jobId: 3, t: 4, d: 20 },
    { jobId: 4, t: 6, d: 18 },
    { jobId: 5, t: 7, d: 20 },
    { jobId: 6, t: 4, d: 40 },
    { jobId: 7, t: 3, d: 35 },
    { jobId: 8, t: 6, d: 42 },
    { jobId: 9, t: 5, d: 25 },
  ];

  const schedule = createSchedule(jobs);

  expect(schedule.length).toBe(9);
  expect(schedule[0]).toEqual({ t: 6, d: 10, c: 6, jobId: 1 });
  expect(schedule[1]).toEqual({ t: 6, d: 18, c: 12, jobId: 4 });
  expect(schedule[2]).toEqual({ t: 4, d: 20, c: 16, jobId: 3 });
  expect(schedule[3]).toEqual({ t: 5, d: 25, c: 21, jobId: 9 });
  expect(schedule[4]).toEqual({ t: 3, d: 35, c: 24, jobId: 7 });
  expect(schedule[5]).toEqual({ t: 4, d: 40, c: 28, jobId: 6 });
  expect(schedule[6]).toEqual({ t: 6, d: 42, c: 34, jobId: 8 });
  expect(schedule[7]).toEqual({ t: 7, d: 20, c: 41, jobId: 5 });
  expect(schedule[8]).toEqual({ t: 8, d: 25, c: 49, jobId: 2 });
});

test('create gantt', () => {
  const jobs = [
    { jobId: 1, t: 6, d: 10, name: 'a' },
    { jobId: 2, t: 8, d: 25, name: 'b' },
    { jobId: 3, t: 4, d: 20, name: 'c' },
    { jobId: 4, t: 6, d: 18, name: 'd' },
    { jobId: 5, t: 7, d: 20, name: 'e' },
    { jobId: 6, t: 4, d: 40, name: 'f' },
    { jobId: 7, t: 3, d: 35, name: 'g' },
    { jobId: 8, t: 6, d: 42, name: 'h' },
    { jobId: 9, t: 5, d: 25, name: 'i' },
  ];

  const template = createGantt(jobs);

  expect(template.length).toBe(1);
  expect(template[0].length).toBe(9);
  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 6, delayed: 0, name: 'a' });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 6, endTime: 12, delayed: 0, name: 'd' });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 12, endTime: 16, delayed: 0, name: 'c' });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 16, endTime: 21, delayed: 0, name: 'i' });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 21, endTime: 24, delayed: 0, name: 'g' });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 24, endTime: 28, delayed: 0, name: 'f' });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 28, endTime: 34, delayed: 0, name: 'h' });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 34, endTime: 41, delayed: 21, name: 'e' });
  expect(template[0][8]).toEqual({ processor: 1, startTime: 41, endTime: 49, delayed: 24, name: 'b' });
});