import React from 'react';
import { Rectangle } from 'recharts';
import theme from '../theme';

export default class Job extends React.PureComponent {
  render() {
    const {
      x,
      y,
      payload: {
        formerStartTime,
        formerEndTime,
        startTime,
        endTime
      },
      xAxis: {
        niceTicks,
        width: axisWidth
      }
    } = this.props;

    if (!endTime) return null;

    const duration = Math.abs(endTime - startTime);

    if (!duration) return null;

    const formerDuration = Math.abs(
      (typeof formerEndTime === 'undefined' ? endTime : formerEndTime)
      - (typeof formerStartTime === 'undefined' ? startTime : formerStartTime)
    );

    const width = (axisWidth / (niceTicks.length - 1)) * duration;
    const height = theme.gantt.job.height;

    return <Box x={x + 5} y={y + 5} width={width} height={height} text={formerDuration} />
  }
}

class Box extends React.PureComponent {
  render() {
    const { x, y, width, height, text } = this.props;
    const { fill, stroke, textColor } = theme.gantt.job;

    return (
      <React.Fragment>
        <Rectangle x={x} y={y - (height / 2)} width={width} height={height} fill={fill} stroke={stroke} />
        <text x={x + (width / 2)} y={y} textAnchor="middle" alignmentBaseline="central" fill={textColor}>{text}</text>
      </React.Fragment>
    );
  }
}