import { find, indexOf, last, map, prop, reduce, sort } from 'rambda';
import { max } from 'ramda';

export const selectAlgorithms = (rows, preempt) => {
  const processorsCount = rows.length;

  if (!processorsCount) return null;

  if (processorsCount === 1) {
    const existD = !!find(prop('d'), rows[0].jobs);
    const existAnc = !!find(({ anc }) => Array.isArray(anc) && anc.length, rows[0].jobs);

    if (existAnc) {
      return ['lawler'];
    }

    if (existD) {
      return ['moore', 'smith'];
    }

    return ['moore'];
  }

  const existAnc = find(
    ({ jobs }) => !!find(({ anc }) => Array.isArray(anc) && anc.length, jobs),
    rows);

  if (existAnc) {
    return ['vahy'];
  }

  let multi = ['campbel', 'grupt', 'palmer'];

  if (processorsCount === 2) {
    multi.push('johnson');
  }

  if (preempt) {
    multi.push('mcnaught');
  }

  return multi;
};

export const najneomeskanejsiResult = (algoResults: []) => {
  if (!algoResults.length) return -1;

  const delaysSum = reduce((acc, processorJobs) => {
    const delays = reduce((acc, { delayed }) => acc + delayed, 0, processorJobs);
    return acc + delays;
  }, 0);

  const delaysTimes = map(delaysSum, algoResults);
  const sortedDelaysTimes = sort((a, b) => a - b, delaysTimes);

  return indexOf(sortedDelaysTimes[0], delaysTimes);
};

export const fastestResult = (algoResults: []) => {
  if (!algoResults.length) return -1;

  const slowestProcessorEndTime = reduce((endTime, processorJobs) => {
    const lastEndTime = last(processorJobs).endTime;
    return max(lastEndTime, endTime);
  }, 0);

  const endTimes = map(slowestProcessorEndTime, algoResults);
  const sortedEndTimes = sort((a, b) => a - b, endTimes);

  return indexOf(sortedEndTimes[0], endTimes);
};