import createGantt, { createSchedule } from './index';

test('create schedule 1', () => {
  const jobsWithOperations = [
    { jobId: 1, t: 4, anc: [] },
    { jobId: 2, t: 6, anc: [1] },
    { jobId: 3, t: 7, anc: [1] },
    { jobId: 4, t: 6, anc: [1] },
    { jobId: 5, t: 4, anc: [2, 3] },
    { jobId: 6, t: 7, anc: [4, 5] },
    { jobId: 7, t: 2, anc: [2, 4, 6] },
  ];

  const schedule = createSchedule(jobsWithOperations, 2);

  expect(schedule.length).toBe(7);
  expect(schedule[0]).toEqual({ jobId: 1, t: 4, c: 4, processor: 1 });
  expect(schedule[1]).toEqual({ jobId: 2, t: 6, c: 10, processor: 1 });
  expect(schedule[2]).toEqual({ jobId: 3, t: 7, c: 17, processor: 1 });
  expect(schedule[3]).toEqual({ jobId: 4, t: 6, c: 6, processor: 2 });
  expect(schedule[4]).toEqual({ jobId: 5, t: 4, c: 10, processor: 2 });
  expect(schedule[5]).toEqual({ jobId: 6, t: 7, c: 17, processor: 2 });
  expect(schedule[6]).toEqual({ jobId: 7, t: 2, c: 19, processor: 2 });
});

test('create schedule 2', () => {
  const jobsWithOperations = [
    { jobId: 1, t: 4, anc: [] },
    { jobId: 2, t: 6, anc: [1] },
    { jobId: 3, t: 7, anc: [1] },
    { jobId: 4, t: 6, anc: [1] },
    { jobId: 5, t: 4, anc: [2, 3] },
    { jobId: 6, t: 7, anc: [4, 5] },
    { jobId: 7, t: 2, anc: [2, 4, 6] },
  ];

  const schedule = createSchedule(jobsWithOperations, 3);

  expect(schedule.length).toBe(7);
  expect(schedule[0]).toEqual({ jobId: 1, t: 4, c: 4, processor: 1 });
  expect(schedule[1]).toEqual({ jobId: 2, t: 6, c: 10, processor: 1 });
  expect(schedule[2]).toEqual({ jobId: 3, t: 7, c: 7, processor: 2 });
  expect(schedule[3]).toEqual({ jobId: 4, t: 6, c: 13, processor: 2 });
  expect(schedule[4]).toEqual({ jobId: 5, t: 4, c: 4, processor: 3 });
  expect(schedule[5]).toEqual({ jobId: 6, t: 7, c: 11, processor: 3 });
  expect(schedule[6]).toEqual({ jobId: 7, t: 2, c: 13, processor: 3 });
});

test('create gantt', () => {
  const jobsWithOperations = [
    { jobId: 1, t: 4, anc: [] },
    { jobId: 2, t: 6, anc: [1] },
    { jobId: 3, t: 7, anc: [1] },
    { jobId: 4, t: 6, anc: [1] },
    { jobId: 5, t: 4, anc: [2, 3] },
    { jobId: 6, t: 7, anc: [4, 5] },
    { jobId: 7, t: 2, anc: [2, 4, 6] },
  ];

  const template = createGantt(jobsWithOperations, 3);

  expect(template.length).toBe(3);
  expect(template[0].length).toBe(2);
  expect(template[1].length).toBe(2);
  expect(template[2].length).toBe(3);

  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 4 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 4, endTime: 10 });

  expect(template[1][0]).toEqual({ processor: 2, startTime: 0, endTime: 7 });
  expect(template[1][1]).toEqual({ processor: 2, startTime: 7, endTime: 13 });

  expect(template[2][0]).toEqual({ processor: 3, startTime: 0, endTime: 4 });
  expect(template[2][1]).toEqual({ processor: 3, startTime: 4, endTime: 11 });
  expect(template[2][2]).toEqual({ processor: 3, startTime: 11, endTime: 13 });
});