import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobs = [
    { jobId: 1, t: 4, d: 10 },
    { jobId: 2, t: 6, d: 25 },
    { jobId: 3, t: 4, d: 20 },
    { jobId: 4, t: 6, d: 18 },
    { jobId: 5, t: 7, d: 40 },
    { jobId: 6, t: 4, d: 50 },
    { jobId: 7, t: 3, d: 35 },
    { jobId: 8, t: 2, d: 52 },
    { jobId: 9, t: 6, d: 46 },
    { jobId: 10, t: 7, d: 28 },
    { jobId: 11, t: 1, d: 50 },
  ];

  const schedule = createSchedule(jobs);

  expect(schedule.length).toBe(11);
  expect(schedule[0]).toEqual({ jobId: 11, t: 1, d: 50, c: 1 });
  expect(schedule[1]).toEqual({ jobId: 3, t: 4, d: 20, c: 5 });
  expect(schedule[2]).toEqual({ jobId: 1, t: 4, d: 10, c: 9 });
  expect(schedule[3]).toEqual({ jobId: 4, t: 6, d: 18, c: 15 });
  expect(schedule[4]).toEqual({ jobId: 2, t: 6, d: 25, c: 21 });
  expect(schedule[5]).toEqual({ jobId: 10, t: 7, d: 28, c: 28 });
  expect(schedule[6]).toEqual({ jobId: 8, t: 2, d: 52, c: 30 });
  expect(schedule[7]).toEqual({ jobId: 7, t: 3, d: 35, c: 33 });
  expect(schedule[8]).toEqual({ jobId: 5, t: 7, d: 40, c: 40 });
  expect(schedule[9]).toEqual({ jobId: 9, t: 6, d: 46, c: 46 });
  expect(schedule[10]).toEqual({ jobId: 6, t: 4, d: 50, c: 50 });
});

test('create gantt', () => {
  const jobs = [
    { jobId: 1, t: 4, d: 10 },
    { jobId: 2, t: 6, d: 25 },
    { jobId: 3, t: 4, d: 20 },
    { jobId: 4, t: 6, d: 18 },
    { jobId: 5, t: 7, d: 40 },
    { jobId: 6, t: 4, d: 50 },
    { jobId: 7, t: 3, d: 35 },
    { jobId: 8, t: 2, d: 52 },
    { jobId: 9, t: 6, d: 46 },
    { jobId: 10, t: 7, d: 28 },
    { jobId: 11, t: 1, d: 50 },
  ];

  const template = createGantt(jobs);

  expect(template.length).toBe(1);
  expect(template[0].length).toBe(11);
  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 1, delayed: 0 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 1, endTime: 5, delayed: 0 });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 5, endTime: 9, delayed: 0 });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 9, endTime: 15, delayed: 0 });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 15, endTime: 21, delayed: 0 });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 21, endTime: 28, delayed: 0 });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 28, endTime: 30, delayed: 0 });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 30, endTime: 33, delayed: 0 });
  expect(template[0][8]).toEqual({ processor: 1, startTime: 33, endTime: 40, delayed: 0 });
  expect(template[0][9]).toEqual({ processor: 1, startTime: 40, endTime: 46, delayed: 0 });
  expect(template[0][10]).toEqual({ processor: 1, startTime: 46, endTime: 50, delayed: 0 });
});