import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 12 }, { t: 8 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 6 }, { t: 13 }, { t: 19 } ] },
    { jobId: 3, operations: [ { t: 15 }, { t: 10 }, { t: 18 } ] },
    { jobId: 4, operations: [ { t: 16 }, { t: 7 }, { t: 21 } ] },
    { jobId: 5, operations: [ { t: 4 }, { t: 4 }, { t: 20 } ] },
    { jobId: 6, operations: [ { t: 3 }, { t: 12 }, { t: 13 } ] },
    { jobId: 7, operations: [ { t: 17 }, { t: 6 }, { t: 8 } ] },
    { jobId: 8, operations: [ { t: 10 }, { t: 2 }, { t: 25 } ] },
  ];

  const schedule = createSchedule(jobsWithOperations, 3);

  expect(schedule.length).toBe(8);
  expect(schedule[0]).toEqual({ jobId: 4, operations: [ { t: 16, c: 16 }, { t: 7, c: 23 }, { t: 21, c: 44 } ] });
  expect(schedule[1]).toEqual({ jobId: 8, operations: [ { t: 10, c: 26 }, { t: 2, c: 28 }, { t: 25, c: 69 } ] });
  expect(schedule[2]).toEqual({ jobId: 3, operations: [ { t: 15, c: 41 }, { t: 10, c: 51 }, { t: 18, c: 87 } ] });
  expect(schedule[3]).toEqual({ jobId: 2, operations: [ { t: 6, c: 47 }, { t: 13, c: 64 }, { t: 19, c: 106 } ] });
  expect(schedule[4]).toEqual({ jobId: 7, operations: [ { t: 17, c: 64 }, { t: 6, c: 70 }, { t: 8, c: 114 } ] });
  expect(schedule[5]).toEqual({ jobId: 5, operations: [ { t: 4, c: 68 }, { t: 4, c: 74 }, { t: 20, c: 134 } ] });
  expect(schedule[6]).toEqual({ jobId: 1, operations: [ { t: 12, c: 80 }, { t: 8, c: 88 }, { t: 11, c: 145 } ] });
  expect(schedule[7]).toEqual({ jobId: 6, operations: [ { t: 3, c: 83 }, { t: 12, c: 100 }, { t: 13, c: 158 } ] });
});

test('create gantt', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 12 }, { t: 8 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 6 }, { t: 13 }, { t: 19 } ] },
    { jobId: 3, operations: [ { t: 15 }, { t: 10 }, { t: 18 } ] },
    { jobId: 4, operations: [ { t: 16 }, { t: 7 }, { t: 21 } ] },
    { jobId: 5, operations: [ { t: 4 }, { t: 4 }, { t: 20 } ] },
    { jobId: 6, operations: [ { t: 3 }, { t: 12 }, { t: 13 } ] },
    { jobId: 7, operations: [ { t: 17 }, { t: 6 }, { t: 8 } ] },
    { jobId: 8, operations: [ { t: 10 }, { t: 2 }, { t: 25 } ] },
  ];

  const template = createGantt(jobsWithOperations, 3);

  expect(template.length).toBe(3);
  expect(template[0].length).toBe(8);
  expect(template[1].length).toBe(8);
  expect(template[2].length).toBe(8);

  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 16 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 16, endTime: 26 });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 26, endTime: 41 });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 41, endTime: 47 });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 47, endTime: 64 });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 64, endTime: 68 });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 68, endTime: 80 });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 80, endTime: 83 });

  expect(template[1][0]).toEqual({ processor: 2, startTime: 16, endTime: 23 });
  expect(template[1][1]).toEqual({ processor: 2, startTime: 26, endTime: 28 });
  expect(template[1][2]).toEqual({ processor: 2, startTime: 41, endTime: 51 });
  expect(template[1][3]).toEqual({ processor: 2, startTime: 51, endTime: 64 });
  expect(template[1][4]).toEqual({ processor: 2, startTime: 64, endTime: 70 });
  expect(template[1][5]).toEqual({ processor: 2, startTime: 70, endTime: 74 });
  expect(template[1][6]).toEqual({ processor: 2, startTime: 80, endTime: 88 });
  expect(template[1][7]).toEqual({ processor: 2, startTime: 88, endTime: 100 });

  expect(template[2][0]).toEqual({ processor: 3, startTime: 23, endTime: 44 });
  expect(template[2][1]).toEqual({ processor: 3, startTime: 44, endTime: 69 });
  expect(template[2][2]).toEqual({ processor: 3, startTime: 69, endTime: 87 });
  expect(template[2][3]).toEqual({ processor: 3, startTime: 87, endTime: 106 });
  expect(template[2][4]).toEqual({ processor: 3, startTime: 106, endTime: 114 });
  expect(template[2][5]).toEqual({ processor: 3, startTime: 114, endTime: 134 });
  expect(template[2][6]).toEqual({ processor: 3, startTime: 134, endTime: 145 });
  expect(template[2][7]).toEqual({ processor: 3, startTime: 145, endTime: 158 });
});