import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobs = [
    { jobId: 1, t: 8, d: 11, anc: [], w: 1 },
    { jobId: 2, t: 5, d: 9, anc: [], w: 1 },
    { jobId: 3, t: 6, d: 10, anc: [], w: 3 },
    { jobId: 4, t: 5, d: 14, anc: [1], w: 2 },
    { jobId: 5, t: 9, d: 19, anc: [1], w: 1 },
    { jobId: 6, t: 3, d: 14, anc: [2, 3, 4], w: 1 },
    { jobId: 7, t: 9, d: 36, anc: [2, 3, 4], w: 2 },
    { jobId: 8, t: 5, d: 39, anc: [2, 3, 4], w: 2 },
    { jobId: 9, t: 8, d: 31, anc: [5, 6], w: 1 },
    { jobId: 10, t: 5, d: 59, anc: [7], w: 2 },
    { jobId: 11, t: 5, d: 61, anc: [8], w: 3 },
  ];

  const schedule = createSchedule(jobs);

  expect(schedule.length).toBe(11);
  expect(schedule[0]).toEqual({ jobId: 3, t: 6, d: 10, c: 6 });
  expect(schedule[1]).toEqual({ jobId: 1, t: 8, d: 11, c: 14 });
  expect(schedule[2]).toEqual({ jobId: 4, t: 5, d: 14, c: 19 });
  expect(schedule[3]).toEqual({ jobId: 2, t: 5, d: 9, c: 24 });
  expect(schedule[4]).toEqual({ jobId: 6, t: 3, d: 14, c: 27 });
  expect(schedule[5]).toEqual({ jobId: 5, t: 9, d: 19, c: 36 });
  expect(schedule[6]).toEqual({ jobId: 7, t: 9, d: 36, c: 45 });
  expect(schedule[7]).toEqual({ jobId: 8, t: 5, d: 39, c: 50 });
  expect(schedule[8]).toEqual({ jobId: 9, t: 8, d: 31, c: 58 });
  expect(schedule[9]).toEqual({ jobId: 11, t: 5, d: 61, c: 63 });
  expect(schedule[10]).toEqual({ jobId: 10, t: 5, d: 59, c: 68 });
});

test('create gantt', () => {
  const jobs = [
    { jobId: 1, t: 8, d: 11, anc: [], w: 1 },
    { jobId: 2, t: 5, d: 9, anc: [], w: 1 },
    { jobId: 3, t: 6, d: 10, anc: [], w: 3 },
    { jobId: 4, t: 5, d: 14, anc: [1], w: 2 },
    { jobId: 5, t: 9, d: 19, anc: [1], w: 1 },
    { jobId: 6, t: 3, d: 14, anc: [2, 3, 4], w: 1 },
    { jobId: 7, t: 9, d: 36, anc: [2, 3, 4], w: 2 },
    { jobId: 8, t: 5, d: 39, anc: [2, 3, 4], w: 2 },
    { jobId: 9, t: 8, d: 31, anc: [5, 6], w: 1 },
    { jobId: 10, t: 5, d: 59, anc: [7], w: 2 },
    { jobId: 11, t: 5, d: 61, anc: [8], w: 3 },
  ];

  const template = createGantt(jobs);

  expect(template.length).toBe(1);
  expect(template[0].length).toBe(11);
  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 6, delayed: 0 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 6, endTime: 14, delayed: 3 });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 14, endTime: 19, delayed: 5 });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 19, endTime: 24, delayed: 15 });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 24, endTime: 27, delayed: 13 });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 27, endTime: 36, delayed: 17 });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 36, endTime: 45, delayed: 9 });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 45, endTime: 50, delayed: 11 });
  expect(template[0][8]).toEqual({ processor: 1, startTime: 50, endTime: 58, delayed: 27 });
  expect(template[0][9]).toEqual({ processor: 1, startTime: 58, endTime: 63, delayed: 2 });
  expect(template[0][10]).toEqual({ processor: 1, startTime: 63, endTime: 68, delayed: 9 });
});