import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 15 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 20 }, { t: 15 } ] },
    { jobId: 3, operations: [ { t: 35 }, { t: 5 } ] },
    { jobId: 4, operations: [ { t: 10 }, { t: 31 } ] },
    { jobId: 5, operations: [ { t: 18 }, { t: 16 } ] },
    { jobId: 6, operations: [ { t: 17 }, { t: 26 } ] },
    { jobId: 7, operations: [ { t: 9 }, { t: 32 } ] },
    { jobId: 8, operations: [ { t: 44 }, { t: 6 } ] },
    { jobId: 9, operations: [ { t: 29 }, { t: 18 } ] },
    { jobId: 10, operations: [ { t: 21 }, { t: 22 } ] },
  ];

  const schedule = createSchedule(jobsWithOperations);

  expect(schedule.length).toBe(10);
  expect(schedule[0]).toEqual({ jobId: 7, operations: [ { t: 9, c: 9 }, { t: 32, c: 41 } ] });
  expect(schedule[1]).toEqual({ jobId: 4, operations: [ { t: 10, c: 19 }, { t: 31, c: 72 } ] });
  expect(schedule[2]).toEqual({ jobId: 6, operations: [ { t: 17, c: 36 }, { t: 26, c: 98 } ] });
  expect(schedule[3]).toEqual({ jobId: 10, operations: [ { t: 21, c: 57 }, { t: 22, c: 120 } ] });
  expect(schedule[4]).toEqual({ jobId: 9, operations: [ { t: 29, c: 86 }, { t: 18, c: 138 } ] });
  expect(schedule[5]).toEqual({ jobId: 5, operations: [ { t: 18, c: 104 }, { t: 16, c: 154 } ] });
  expect(schedule[6]).toEqual({ jobId: 2, operations: [ { t: 20, c: 124 }, { t: 15, c: 169 } ] });
  expect(schedule[7]).toEqual({ jobId: 1, operations: [ { t: 15, c: 139 }, { t: 11, c: 180 } ] });
  expect(schedule[8]).toEqual({ jobId: 8, operations: [ { t: 44, c: 183 }, { t: 6, c: 189 } ] });
  expect(schedule[9]).toEqual({ jobId: 3, operations: [ { t: 35, c: 218 }, { t: 5, c: 223 } ] });
});

test('create gantt', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 15 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 20 }, { t: 15 } ] },
    { jobId: 3, operations: [ { t: 35 }, { t: 5 } ] },
    { jobId: 4, operations: [ { t: 10 }, { t: 31 } ] },
    { jobId: 5, operations: [ { t: 18 }, { t: 16 } ] },
    { jobId: 6, operations: [ { t: 17 }, { t: 26 } ] },
    { jobId: 7, operations: [ { t: 9 }, { t: 32 } ] },
    { jobId: 8, operations: [ { t: 44 }, { t: 6 } ] },
    { jobId: 9, operations: [ { t: 29 }, { t: 18 } ] },
    { jobId: 10, operations: [ { t: 21 }, { t: 22 } ] },
  ];

  const template = createGantt(jobsWithOperations);

  expect(template.length).toBe(2);
  expect(template[0].length).toBe(10);
  expect(template[1].length).toBe(10);

  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 9 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 9, endTime: 19 });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 19, endTime: 36 });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 36, endTime: 57 });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 57, endTime: 86 });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 86, endTime: 104 });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 104, endTime: 124 });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 124, endTime: 139 });
  expect(template[0][8]).toEqual({ processor: 1, startTime: 139, endTime: 183 });
  expect(template[0][9]).toEqual({ processor: 1, startTime: 183, endTime: 218 });

  expect(template[1][0]).toEqual({ processor: 2, startTime: 9, endTime: 41 });
  expect(template[1][1]).toEqual({ processor: 2, startTime: 41, endTime: 72 });
  expect(template[1][2]).toEqual({ processor: 2, startTime: 72, endTime: 98 });
  expect(template[1][3]).toEqual({ processor: 2, startTime: 98, endTime: 120 });
  expect(template[1][4]).toEqual({ processor: 2, startTime: 120, endTime: 138 });
  expect(template[1][5]).toEqual({ processor: 2, startTime: 138, endTime: 154 });
  expect(template[1][6]).toEqual({ processor: 2, startTime: 154, endTime: 169 });
  expect(template[1][7]).toEqual({ processor: 2, startTime: 169, endTime: 180 });
  expect(template[1][8]).toEqual({ processor: 2, startTime: 183, endTime: 189 });
  expect(template[1][9]).toEqual({ processor: 2, startTime: 218, endTime: 223 });
});