import createGantt, { createSchedule } from './index';

test('create schedule', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 12 }, { t: 8 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 6 }, { t: 13 }, { t: 19 } ] },
    { jobId: 3, operations: [ { t: 15 }, { t: 10 }, { t: 18 } ] },
    { jobId: 4, operations: [ { t: 16 }, { t: 7 }, { t: 21 } ] },
    { jobId: 5, operations: [ { t: 4 }, { t: 4 }, { t: 20 } ] },
    { jobId: 6, operations: [ { t: 3 }, { t: 12 }, { t: 13 } ] },
    { jobId: 7, operations: [ { t: 17 }, { t: 6 }, { t: 8 } ] },
    { jobId: 8, operations: [ { t: 10 }, { t: 2 }, { t: 25 } ] },
  ];

  const schedule = createSchedule(jobsWithOperations, 3);

  expect(schedule.length).toBe(8);
  expect(schedule[0]).toEqual({ jobId: 5, operations: [ { t: 4, c: 4 }, { t: 4, c: 8 }, { t: 20, c: 28 } ] });
  expect(schedule[1]).toEqual({ jobId: 8, operations: [ { t: 10, c: 14 }, { t: 2, c: 16 }, { t: 25, c: 53 } ] });
  expect(schedule[2]).toEqual({ jobId: 6, operations: [ { t: 3, c: 17 }, { t: 12, c: 29 }, { t: 13, c: 66 } ] });
  expect(schedule[3]).toEqual({ jobId: 2, operations: [ { t: 6, c: 23 }, { t: 13, c: 42 }, { t: 19, c: 85 } ] });
  expect(schedule[4]).toEqual({ jobId: 4, operations: [ { t: 16, c: 39 }, { t: 7, c: 49 }, { t: 21, c: 106 } ] });
  expect(schedule[5]).toEqual({ jobId: 3, operations: [ { t: 15, c: 54 }, { t: 10, c: 64 }, { t: 18, c: 124 } ] });
  expect(schedule[6]).toEqual({ jobId: 1, operations: [ { t: 12, c: 66 }, { t: 8, c: 74 }, { t: 11, c: 135 } ] });
  expect(schedule[7]).toEqual({ jobId: 7, operations: [ { t: 17, c: 83 }, { t: 6, c: 89 }, { t: 8, c: 143 } ] });
});

test('create gantt', () => {
  const jobsWithOperations = [
    { jobId: 1, operations: [ { t: 12 }, { t: 8 }, { t: 11 } ] },
    { jobId: 2, operations: [ { t: 6 }, { t: 13 }, { t: 19 } ] },
    { jobId: 3, operations: [ { t: 15 }, { t: 10 }, { t: 18 } ] },
    { jobId: 4, operations: [ { t: 16 }, { t: 7 }, { t: 21 } ] },
    { jobId: 5, operations: [ { t: 4 }, { t: 4 }, { t: 20 } ] },
    { jobId: 6, operations: [ { t: 3 }, { t: 12 }, { t: 13 } ] },
    { jobId: 7, operations: [ { t: 17 }, { t: 6 }, { t: 8 } ] },
    { jobId: 8, operations: [ { t: 10 }, { t: 2 }, { t: 25 } ] },
  ];

  const template = createGantt(jobsWithOperations, 3);

  expect(template.length).toBe(3);
  expect(template[0].length).toBe(8);
  expect(template[1].length).toBe(8);
  expect(template[2].length).toBe(8);

  expect(template[0][0]).toEqual({ processor: 1, startTime: 0, endTime: 4 });
  expect(template[0][1]).toEqual({ processor: 1, startTime: 4, endTime: 14 });
  expect(template[0][2]).toEqual({ processor: 1, startTime: 14, endTime: 17 });
  expect(template[0][3]).toEqual({ processor: 1, startTime: 17, endTime: 23 });
  expect(template[0][4]).toEqual({ processor: 1, startTime: 23, endTime: 39 });
  expect(template[0][5]).toEqual({ processor: 1, startTime: 39, endTime: 54 });
  expect(template[0][6]).toEqual({ processor: 1, startTime: 54, endTime: 66 });
  expect(template[0][7]).toEqual({ processor: 1, startTime: 66, endTime: 83 });

  expect(template[1][0]).toEqual({ processor: 2, startTime: 4, endTime: 8 });
  expect(template[1][1]).toEqual({ processor: 2, startTime: 14, endTime: 16 });
  expect(template[1][2]).toEqual({ processor: 2, startTime: 17, endTime: 29 });
  expect(template[1][3]).toEqual({ processor: 2, startTime: 29, endTime: 42 });
  expect(template[1][4]).toEqual({ processor: 2, startTime: 42, endTime: 49 });
  expect(template[1][5]).toEqual({ processor: 2, startTime: 54, endTime: 64 });
  expect(template[1][6]).toEqual({ processor: 2, startTime: 66, endTime: 74 });
  expect(template[1][7]).toEqual({ processor: 2, startTime: 83, endTime: 89 });

  expect(template[2][0]).toEqual({ processor: 3, startTime: 8, endTime: 28 });
  expect(template[2][1]).toEqual({ processor: 3, startTime: 28, endTime: 53 });
  expect(template[2][2]).toEqual({ processor: 3, startTime: 53, endTime: 66 });
  expect(template[2][3]).toEqual({ processor: 3, startTime: 66, endTime: 85 });
  expect(template[2][4]).toEqual({ processor: 3, startTime: 85, endTime: 106 });
  expect(template[2][5]).toEqual({ processor: 3, startTime: 106, endTime: 124 });
  expect(template[2][6]).toEqual({ processor: 3, startTime: 124, endTime: 135 });
  expect(template[2][7]).toEqual({ processor: 3, startTime: 135, endTime: 143 });
});