import React, { PureComponent } from 'react';
import Form from './components/Form';
import Gantt from './components/Gantt';
import { normalizeData } from './ganttUtils';

const algoData = [
  [
    { startTime: 1, endTime: 3, processor: 1, name: 'UI dizajnér' },
    { startTime: 4, endTime: 6, processor: 1, name: 'UX dizajnér' },
    { startTime: 6, endTime: 10, processor: 1, name: 'UI dizajnér' },
  ],
  [
    { startTime: 6, endTime: 10, processor: 2, name: 'UI dizajnér' },
    { startTime: 22, endTime: 23, processor: 2, name: 'UI dizajnér' },
    { startTime: 23, endTime: 24, processor: 2, name: 'UI dizajnér' },
    { startTime: 24, endTime: 25, processor: 2, name: 'UI dizajnér' },
  ],
  [
    { startTime: 10, endTime: 16, processor: 3, name: 'UI dizajnér' },
  ],
  [
    { startTime: 10, endTime: 16, processor: 4, name: 'UI dizajnér' },
  ],
  [
    { startTime: 10, endTime: 16, processor: 5, name: 'UI dizajnér' },
  ],
  [
    { startTime: 10, endTime: 16, processor: 6, name: 'UI dizajnér' },
  ]
];

const data = normalizeData(algoData);

class App extends PureComponent {
  render() {
    return (
      <div style={{ padding: 20 }}>
        <Form />
        <Gantt data={data} />
      </div>
    );
  }
}

export default App;
