require_relative "../../../test_helper.rb"
require Rubysermon::MOD_PATH + "/cpu.rb"

class Cpu_test < MiniTest::Unit::TestCase

	def setup
		@cpu = Rubysermon::Cpu.new
	end

	def test_y_axis
		assert_equal("CPU Load", @cpu.y_axis_name)
	end

	def test_graph_name
		assert_match(/^CPU Load In Time \(CPUs: [\d]+\)$/, @cpu.graph_name)
	end

	def test_cpu_load
		assert_match(/^\d\.\d{2}$/, @cpu.results())
	end
end