module Rubysermon
	class Cpu < ModTemplate

		def initialize
			@y_axis = "CPU Load"
			@graph_name = "CPU Load In Time"

			@cpu_count = File.readlines("/proc/stat").select { |line|
				line =~ /^cpu[\d]/
			}.length

			@cpu_load = 0
			@options = {notify_threshold: @cpu_count*0.90}
		end

		def load_options(options)

		end

		def results
			@cpu_load = File.read("/proc/loadavg").split(" ").first.to_s
		end

		def notify?
			@cpu_load >= @options[:notify_threshold]
		end

		def y_axis_name
			@y_axis
		end

		def graph_name
			"#@graph_name (CPUs: #@cpu_count)"
		end
	end
end