require_relative 'test_helper.rb'

class Rubysermon_test < MiniTest::Unit::TestCase

	def teardown
		ARGV.clear
	end

	def test_wrong_refresh_time
		ARGV[0] = "#{TEST_PATH}/fixtures/short_repeat_period.json"
		app = Rubysermon::App.new

		exception = assert_raises(SystemExit) do
			app.run()
		end

		assert_equal("Repeat cycle is too short", exception.message)
	end

	def test_empty_modules
		ARGV[0] = "#{TEST_PATH}/fixtures/empty_modules.json"
		app = Rubysermon::App.new

		exception = assert_raises(SystemExit) do
			app.run()
		end

		assert_equal("There are no enabled modules", exception.message)
	end

	def test_empty_config1
		ARGV[0] = "#{TEST_PATH}/fixtures/empty1.json"
		app = Rubysermon::App.new

		exception = assert_raises(SystemExit) do
			app.run()
		end

		assert_equal("There are no enabled modules", exception.message)
	end

	def test_empty_config2
		ARGV[0] = "#{TEST_PATH}/fixtures/empty2.json"
		app = Rubysermon::App.new


		exception = ""
		assert_output(nil, /Invalid JSON file/) do
			exception = assert_raises(SystemExit) do
				app.run()
			end
		end

		assert_equal("There are no enabled modules", exception.message)
	end

	def test_wrong_config_path
		ARGV[0] = "/wrong_path"
		exception = assert_raises(SystemExit) do
			Rubysermon::App.new
		end

		assert_equal("Wrong config file path. Exiting.", exception.message)
	end
end