require 'json'

module Rubysermon
	class Configurator

		def initialize(config_path)
			raw_json = File.read(config_path)

			begin
				@parsed_settings = JSON.parse(raw_json, symbolize_names: true)
			rescue JSON::ParserError
				@parsed_settings = {}
				$stderr.puts "Invalid JSON file"
			end
		end

		def get_settings
			@parsed_settings
		end
	end
end