require_relative "../../../test_helper.rb"
require Rubysermon::MOD_PATH + "/cpu.rb"

class Cpu_test < MiniTest::Unit::TestCase

	def setup
		@cpu = Rubysermon::Cpu.new
	end

	def test_labels
		labels = @cpu.graph_labels

		assert_equal("CPU Load", labels[:y_axis])
		assert_match(/^CPU Load In Time \(CPUs: [\d]+\)$/, labels[:graph_name])
	end

	def test_cpu_load
		assert_match(/^\d\.\d{1,2}$/, @cpu.results().to_s)
	end

	def test_notify?
		@cpu.load_options({notify_threshold: 0})
		assert_equal(true, @cpu.notify?)

		#assume you have no more than 999 cpu load
		@cpu.load_options({notify_threshold: 999})
		assert_equal(false, @cpu.notify?)
	end
end