require "sqlite3"

module Rubysermon
	class DB

		def initialize(db_path)
			@db = SQLite3::Database.new(db_path)
			@db.execute(self.initialize_db)
		end

		private

		def self.initialize_db
			<<-SQL
				DROP TABLE IF EXISTS `history`;
				CREATE TABLE `history` (
					`date` INTEGER NOT NULL,
					`mod_hash` VARCHAR(20) NOT NULL,
					`value` REAL NOT NULL
				);
				CREATE INDEX date_index ON `history` (`date`);
			SQL
		end

	end
end
